module DAC38J84_CPLD
(

// Inputs from FT2232H
input 	FTDI_SCLK,
input 	FTDI_SDIO,
output 	FTDI_SDO,
input 	FTDI_SEN_DAC,
input 	FTDI_SEN_LMK,
output 	FTDI_DAC_SDIO,
output 	FTDI_LMK_SDIO,
input 	FTDI_DIR_CONTROL,

input 	FTDI_TCK,
input 	FTDI_TDI,
output 	FTDI_TDO,
input 	FTDI_TMS,
input 	FTDI_TRSTB,
input 	FTDI_A5,
input 	FTDI_A6,
input		FTDI_A7,

// SPI Inputs from FMC Connector
input 	FMC_SCLK,
input 	FMC_SDIO,
output 	FMC_SDO,
input 	FMC_SEN_DAC,
input 	FMC_SEN_LMK,
output 	FMC_DAC_SDIO,
output 	FMC_LMK_SDIO,
input 	FMC_DIR_CONTROL,

// FMC or FTDI SPI Selector
input		FMC_OR_FTDI_SELECTOR,

// DAC SPI control lines
output	DAC_SCLK,
output	DAC_SDENB,
inout		DAC_SDIO,
input		DAC_SDO,

// JTAG output to DAC
output 	reg 	DAC_TCLK,
output	DAC_TDI,
input		DAC_TDO,
output	DAC_TMS,
output	reg 	DAC_TRSTB,

// LMK SPI control lines
output 	LMK_SCK,
output 	LMK_CS,
inout 	LMK_SDIO,
input 	LMK_SDO,

output [9:0] LMK_SPI_HEADER,
output [9:0] DAC_SPI_HEADER,

input SYSREF_BUTTON,
output LMK_CPLD_SYNC

);

assign LMK_CPLD_SYNC = SYSREF_BUTTON;

assign LMK_SPI_HEADER[0] = LMK_SCK;
assign LMK_SPI_HEADER[1] = SDIO_ROUTE;
assign LMK_SPI_HEADER[2] = LMK_SDO;
assign LMK_SPI_HEADER[3] = LMK_CS;

assign DAC_SPI_HEADER[0] = DAC_SCLK;
assign DAC_SPI_HEADER[1] = SDIO_ROUTE;
assign DAC_SPI_HEADER[2] = DAC_SDO;
assign DAC_SPI_HEADER[3] = DAC_SDENB;
assign DAC_SPI_HEADER[4] = DAC_TCLK;
assign DAC_SPI_HEADER[5] = DAC_TDI;
assign DAC_SPI_HEADER[6] = DAC_TDO;
assign DAC_SPI_HEADER[7] = DAC_TMS;
assign DAC_SPI_HEADER[8] = DAC_TRSTB;


assign DAC_SDIO = (DIR_CONTROL_ROUTE) ? SDIO_ROUTE : 1'bz;
assign LMK_SDIO = (DIR_CONTROL_ROUTE) ? SDIO_ROUTE : 1'bz;


// On startup, the FTDI pins are all high. The upper 3 pins are not used
// for JTAG. If any of them are high (i.e at startup) then  the DAC_TRSTB
// and DAC_TCLK output will be held low to hold JTAG in reset. To use JTAG, these 
//	three pins need to be set low by the softare. When these are low, TCLK
//	and TRSTB is passed straight from the FTDI chip to the DAC.
always @ (*) begin
	if(FTDI_A7 || FTDI_A6 || FTDI_A5) begin
		DAC_TRSTB <= 1'b0;
		DAC_TCLK <= 1'b0;
	end else begin
		DAC_TRSTB <= FTDI_TRSTB;
		DAC_TCLK <= FTDI_TCK;
	end
end

// Pass all other JTAG signals straight through
assign DAC_TDI = FTDI_TDI;
assign FTDI_TDO = DAC_TDO;
assign DAC_TMS = FTDI_TMS;
//assign DAC_TRSTB = FTDI_TRSTB;
//assign DAC_TCLK = FTDI_TCK;

// Control routing of SPI signals to/from the FMC connector and FTDI chip
// If the control pin is high, take signals from FMC
// If the control pin is low, take signals from FTDI
reg SCLK_ROUTE;
reg SDIO_ROUTE;
reg SEN_DAC_ROUTE;
reg SEN_LMK_ROUTE;
reg DIR_CONTROL_ROUTE;
always @ (*) begin
	if(FMC_OR_FTDI_SELECTOR) begin
		SCLK_ROUTE <= FMC_SCLK;
		SDIO_ROUTE <= FMC_SDIO;
		SEN_DAC_ROUTE <= FMC_SEN_DAC;
		SEN_LMK_ROUTE <= FMC_SEN_LMK;
		DIR_CONTROL_ROUTE <= FMC_DIR_CONTROL;
	end else begin
		SCLK_ROUTE <= FTDI_SCLK;
		SDIO_ROUTE <= FTDI_SDIO;
		SEN_DAC_ROUTE <= FTDI_SEN_DAC;
		SEN_LMK_ROUTE <= FTDI_SEN_LMK;
		DIR_CONTROL_ROUTE <= FTDI_DIR_CONTROL;
	end
end

// Route SCLK straight from FMC/FTDI to DAC/LMK
assign DAC_SCLK = SCLK_ROUTE;
assign LMK_SCK = SCLK_ROUTE;

// Route SEN straight from FMC/FTDI to DAC/LMK
assign DAC_SDENB = SEN_DAC_ROUTE;
assign LMK_CS = SEN_LMK_ROUTE;

/* Disable using SDIO of the FTDI chip as readback.
	Uncomment to allow SDIO to be readback in 3-wire mode.
	Also, change the FTDI and FMC SDIO pins to inout.

// Control direction for 3-wire and 4-wire interface
// 1'b1 = write to device, 1'b0 = read from device
reg DAC_LMK_SELECTION;

// If the LMK SEN is active (low) and the DAC SEN is high,
// then readback from LMK, otherwise readback from DAC
always @ (*) begin
	if(!SEN_LMK_ROUTE && SEN_DAC_ROUTE) begin
		DAC_LMK_SELECTION <= LMK_SDIO;
	end else begin
		DAC_LMK_SELECTION <= DAC_SDIO;
	end
end

assign FTDI_SDIO = (!DIR_CONTROL_ROUTE && !FMC_OR_FTDI_SELECTOR) ? DAC_LMK_SELECTION : 1'bz;
assign FMC_SDIO  = (!DIR_CONTROL_ROUTE && FMC_OR_FTDI_SELECTOR)  ? DAC_LMK_SELECTION : 1'bz;

*/

// Send DAC and LMK SDIO to the individual readback pins
assign DAC_SDIO = (DIR_CONTROL_ROUTE) ? SDIO_ROUTE : 1'bz;
assign LMK_SDIO = (DIR_CONTROL_ROUTE) ? SDIO_ROUTE : 1'bz;
assign FTDI_DAC_SDIO = (!FMC_OR_FTDI_SELECTOR) ? DAC_SDIO : 1'bz;
assign FTDI_LMK_SDIO = (!FMC_OR_FTDI_SELECTOR) ? LMK_SDIO : 1'bz;
assign FMC_DAC_SDIO = (FMC_OR_FTDI_SELECTOR) ? DAC_SDIO : 1'bz;
assign FMC_LMK_SDIO = (FMC_OR_FTDI_SELECTOR) ? LMK_SDIO : 1'bz;

// Control routing of LMK and DAC SDO to FTDI or FMC
reg SDO_ROUTE;
always @ (*) begin
	if(!FTDI_SEN_LMK && FTDI_SEN_DAC) begin
		SDO_ROUTE <= LMK_SDO;
	end else begin
		SDO_ROUTE <= DAC_SDO;
	end
end

assign FTDI_SDO = (!FMC_OR_FTDI_SELECTOR) ? SDO_ROUTE : 1'bz;
assign FMC_SDO = (FMC_OR_FTDI_SELECTOR) ? SDO_ROUTE : 1'bz;
	 
endmodule 